﻿<#  GARYTOWN.COM / @gwblok

Custom Actions in the Setup Process
    This script creates each of the 6 batch files, along with associated powershell files.
    It then populates the Batch file to call the PS File
    It then populates the PS File with the command to create a time stamp.

    Goal: Confirm when the Scripts run and compare to other logs

    Docs: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/windows-setup-enable-custom-actions


    Changes:
    2021.05.06 - Disabled the Reboot Bypass Function in the Pre-Commit.
    2021.06.08 - Added Logging into SMSTSlog
    2021.06.08 - Removed all Bypass code
#>

$ScriptVer = "21.08.20"
Write-Output "-----------------------------------------"
Write-Output "Starting - PreCommit Script: $ScriptVer "
#Setup TS Environement
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    $registryPath = "HKLM:\$($tsenv.Value("RegistryPath"))\$($tsenv.Value("SMSTS_Build"))" #Sets Registry Location
    Write-Output "Confirmed Running in TS with Registry Path: $registryPath"
}
catch
{
	Write-Verbose "Not running in a task sequence."
}





if (Test-Path -Path $registryPath){}
Else{New-Item -Path $registryPath} 

$RunOncePath = "$($env:windir)\System32\update\runonce"
if (Test-Path -Path $RunOncePath){Remove-Item -Path $RunOncePath -Force -Recurse}

$PreCommitScript = {

$LogFile = "C:\Windows\ccm\Logs\WaaS_CustomActions.log"

$ScriptName = $MyInvocation.MyCommand.Name
#region: CMTraceLog Function formats logging in CMTrace style
function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

CMTraceLog -Message  "---Starting $ScriptName Script---" -Type 1 -LogFile $LogFile -Component PreCommit

Remove-ItemProperty -Path "HKLM:SOFTWARE\Policies\Microsoft\Windows\Personalization" -Name "LockScreenImage" -Force -ErrorAction SilentlyContinue
CMTraceLog -Message  "Removed LockScreen Image RegKey" -Type 1 -LogFile $LogFile -Component PreCommit
Remove-Item "$env:ProgramData\OSDReqs" -Force -Recurse -ErrorAction SilentlyContinue
CMTraceLog -Message  "Removed Upgrade LockScreen Image" -Type 1 -LogFile $LogFile -Component PreCommit
#Will use different Recovery Process if failure happens after downlevel phase.
Remove-Item "$env:ProgramData\RollbackRecovery" -Force -Recurse -ErrorAction SilentlyContinue
CMTraceLog -Message  "Removed Rollback Recovery Files in ProgramData" -Type 1 -LogFile $LogFile -Component PreCommit
Remove-Item "$env:ProgramData\OSUninstall" -Force -Recurse -ErrorAction SilentlyContinue
CMTraceLog -Message  "Removed OSUninstall Files in ProgramData" -Type 1 -LogFile $LogFile -Component PreCommit

CMTraceLog -Message  "---Exiting $ScriptName Script---" -Type 1 -LogFile $LogFile -Component PreCommit
}



#Custom Action Table (CA = CustomAction)
$RunScriptTable = @(
   
    @{ Script = "CA_PreCommit"; BatFile = 'precommit.cmd'; ps1file = 'precommit.ps1'; Type = 'RunOnce'; Path = "$RunOncePath"}
)



$ScriptGUID = New-Guid

Write-Output "Creating RunScripts with in GUID: $ScriptGUID"

ForEach ($RunScript in $RunScriptTable)
    {
    
    Write-Output $RunScript.Script

    $BatFilePath = "$($RunScript.Path)\$($ScriptGUID)\$($RunScript.batFile)"
    $PSFilePath = "$($RunScript.Path)\$($ScriptGUID)\$($RunScript.ps1File)"
        
    #Create Batch File to Call PowerShell File
    Write-Output "  Creating $BatFilePath"     
    New-Item -Path $BatFilePath -ItemType File -Force
    Add-Content -Path $BatFilePath $PreCommitCmd
    $CustomActionContent = New-Object system.text.stringbuilder
    [void]$CustomActionContent.Append('%windir%\System32\WindowsPowerShell\v1.0\powershell.exe -ExecutionPolicy ByPass -File')
    [void]$CustomActionContent.Append(" $PSFilePath")
    Add-Content -Path $BatFilePath -Value $CustomActionContent.ToString()

    #Create PowerShell File to do actions
    Write-Output "  Creating $PSFilePath"  
    New-Item -Path $PSFilePath -ItemType File -Force
    Add-Content -Path $PSFilePath $PreCommitScript
    #$PreCommitScript | Out-File -FilePath $PSFilePath -Force
    Add-Content -Path $PSFilePath  '$TimeStamp = Get-Date -f s'
    $CustomActionContentPS = New-Object system.text.stringbuilder
    [void]$CustomActionContentPS.Append('$RegistryPath = ') 
    [void]$CustomActionContentPS.Append("""$RegistryPath""")
    Add-Content -Path $PSFilePath -Value $CustomActionContentPS.ToString()
    $CustomActionContentPS = New-Object system.text.stringbuilder
    [void]$CustomActionContentPS.Append('$keyname = ') 
    [void]$CustomActionContentPS.Append("""$($RunScript.Script)_$($RunScript.Type)""")
    Add-Content -Path $PSFilePath -Value $CustomActionContentPS.ToString()
    Add-Content -Path $PSFilePath -Value 'New-ItemProperty -Path $registryPath -Name $keyname -Value $TimeStamp -Force'
        
    }

Write-Output "Complete - PreCommit Script: $ScriptVer "
Write-Output "-----------------------------------------"
